/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.config.StringListConfig;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.base.Priority;
import com.mlib.contexts.data.ILevelData;
import com.mlib.contexts.data.IPositionData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.server.ServerLifecycleHooks;

public class OnLoot {
    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Data dispatch(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        return Contexts.get(Data.class).dispatch(new Data(generatedLoot, context));
    }

    public static Condition<Data> hasBlockState() {
        return new Condition<Data>(data -> data.blockState != null);
    }

    public static Condition<Data> hasDamageSource() {
        return new Condition<Data>(data -> data.damageSource != null);
    }

    public static Condition<Data> hasKiller() {
        return new Condition<Data>(data -> data.killer != null);
    }

    public static Condition<Data> hasEntity() {
        return new Condition<Data>(data -> data.entity != null);
    }

    public static Condition<Data> hasLastDamagePlayer() {
        return new Condition<Data>(data -> data.lastDamagePlayer != null);
    }

    public static Condition<Data> hasTool() {
        return new Condition<Data>(data -> data.tool != null);
    }

    public static Condition<Data> hasOrigin() {
        return new Condition<Data>(data -> data.origin != null);
    }

    public static Condition<Data> is(StringListConfig ids) {
        return new Condition<Data>(data -> ids.contains(data.context.getQueriedLootTableId().toString())).priority(Priority.HIGH).configurable(true).addConfig(ids);
    }

    public static Condition<Data> is(String ... defaultIds) {
        return OnLoot.is(DefaultConfigs.is(defaultIds));
    }

    public static Condition<Data> is(ResourceLocation ... ids) {
        return OnLoot.is((String[])Stream.of(ids).map(ResourceLocation::toString).toArray(String[]::new));
    }

    public static class Data
    implements ILevelData,
    IPositionData {
        public final ObjectArrayList<ItemStack> generatedLoot;
        public final LootContext context;
        @Nullable
        public final BlockState blockState;
        @Nullable
        public final DamageSource damageSource;
        @Nullable
        public final Entity killer;
        @Nullable
        public final Entity entity;
        @Nullable
        public final Player lastDamagePlayer;
        @Nullable
        public final ItemStack tool;
        @Nullable
        public final Vec3 origin;

        public Data(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            this.generatedLoot = generatedLoot;
            this.context = context;
            this.blockState = (BlockState)this.getParameter(LootContextParams.f_81461_);
            this.damageSource = (DamageSource)this.getParameter(LootContextParams.f_81457_);
            this.killer = (Entity)this.getParameter(LootContextParams.f_81458_);
            this.entity = (Entity)this.getParameter(LootContextParams.f_81455_);
            this.lastDamagePlayer = (Player)this.getParameter(LootContextParams.f_81456_);
            this.tool = (ItemStack)this.getParameter(LootContextParams.f_81463_);
            this.origin = (Vec3)this.getParameter(LootContextParams.f_81460_);
        }

        @Override
        public Level getLevel() {
            return this.entity != null ? this.entity.m_9236_() : null;
        }

        @Override
        public Vec3 getPosition() {
            return this.origin != null ? this.origin : new Vec3(0.0, 0.0, 0.0);
        }

        public void addAsChestLoot(ResourceLocation id) {
            ObjectArrayList itemStacks = ServerLifecycleHooks.getCurrentServer().m_129898_().m_79217_(id).m_230922_(new LootContext.Builder(this.getServerLevel()).m_78972_(LootContextParams.f_81460_, (Object)this.origin).m_78975_(LootContextParamSets.f_81411_));
            this.generatedLoot.addAll((Collection)itemStacks);
        }

        @Nullable
        private <Type> Type getParameter(LootContextParam<Type> parameter) {
            return (Type)this.context.m_78953_(parameter);
        }
    }

    public static class DefaultConfigs {
        public static StringListConfig is(String ... defaultIds) {
            StringListConfig ids = new StringListConfig(defaultIds);
            ids.name("loot_table_ids").comment("Determines to which loot tables it is applicable.");
            return ids;
        }
    }
}

